// FAT-X-PlorerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FAT-X-Plorer.h"
#include "FAT-X-PlorerDlg.h"
#include "cderr.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()

};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CFATXPlorerDlg dialog



CFATXPlorerDlg::CFATXPlorerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFATXPlorerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bDelete=FALSE;
}
CFATXPlorerDlg::~CFATXPlorerDlg()
{
	m_FATXDisk.ExitInstance();
}

void CFATXPlorerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE_EXPLORER, m_ctrlFileView);
	DDX_Control(pDX, IDC_LIST1, m_lcFiles);
}

BEGIN_MESSAGE_MAP(CFATXPlorerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedButton1)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_EXPLORER, OnTvnSelchangedTreeExplorer)
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnBnClickedButtonDelete)
	ON_BN_CLICKED(IDC_BUTTON_Add, OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_ADDDIR, OnBnClickedButtonAdddir)
	ON_BN_CLICKED(IDC_BUTTON3, OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnBnClickedButton4)
END_MESSAGE_MAP()


// CFATXPlorerDlg message handlers

BOOL CFATXPlorerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_lcFiles.InsertColumn(0,"Name",LVCFMT_LEFT,200,0);
	m_lcFiles.InsertColumn(1,"Size",LVCFMT_RIGHT,100,1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFATXPlorerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFATXPlorerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFATXPlorerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CFATXPlorerDlg::OnBnClickedButton1()
{
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260];       // buffer for file name
	ZeroMemory(szFile,260);
	HWND hwnd=GetSafeHwnd();              // owner window

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = NULL;
	ofn.nFilterIndex = 0;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	// Display the Open dialog box. 

	if (GetOpenFileName(&ofn)==NULL) 
	{
		return;
	}

	if (m_FATXDisk.InitInstance(ofn.lpstrFile))
	{
		MessageBox("this is not a valid xbox drive image","ERROR");
		return;
	}

	m_FATXDisk.Clear();

	m_FATXDisk.ReadDirectoryEntries();

	RedrawList();

}

int CFATXPlorerDlg::RedrawList(void)
{
	m_ctrlFileView.DeleteAllItems();

	AddDirectoryToList(m_FATXDisk.m_pPartitions[0].m_pRootDirectory,NULL,"Cache 1");
	AddDirectoryToList(m_FATXDisk.m_pPartitions[1].m_pRootDirectory,NULL,"Cache 2");
	AddDirectoryToList(m_FATXDisk.m_pPartitions[2].m_pRootDirectory,NULL,"Cache 3");
	AddDirectoryToList(m_FATXDisk.m_pPartitions[3].m_pRootDirectory,NULL,"System");
	AddDirectoryToList(m_FATXDisk.m_pPartitions[4].m_pRootDirectory,NULL,"Data");
	return 0;
}

int CFATXPlorerDlg::AddDirectoryToList(CFATXDirectory * pIn,HTREEITEM hParent,char *strNameOverride)
{
	if(!pIn) return 1;

	BYTE strName[41];
	ZeroMemory(strName,41);
	memcpy(strName,pIn->m_deInfo.byteFileName,40);
	strName[pIn->m_deInfo.byteSizeOfFilename]=0;

	HTREEITEM hItem = 0;

	if(strNameOverride)
	{
		hItem = m_ctrlFileView.InsertItem(TVIF_TEXT|TVIF_PARAM,
			(LPCTSTR)strNameOverride,NULL,NULL,NULL,NULL,(LPARAM)pIn,hParent,NULL);
	}
	else
	{
		hItem = m_ctrlFileView.InsertItem(TVIF_TEXT|TVIF_PARAM,
			(LPCTSTR)strName,NULL,NULL,NULL,NULL,(LPARAM)pIn,hParent,NULL);
	}

	if(pIn->m_pDirChild)
		AddDirectoryToList(pIn->m_pDirChild,hItem);
	if(pIn->m_pDirNext)
		AddDirectoryToList(pIn->m_pDirNext,hParent);

	return 0;
}

void CFATXPlorerDlg::OnTvnSelchangedTreeExplorer(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(m_bDelete) return;
	
	HTREEITEM item = m_ctrlFileView.GetSelectedItem();
	if (!item) return;
	CFATXDirectory *pDir=((CFATXDirectory*)(pNMTreeView->itemNew.lParam));
	if(!pDir) 	return;

	m_lcFiles.DeleteAllItems();

	CFATXFile *pFile=pDir->m_pNextFile;
    int nIndex=0;

	while(pFile)
	{
		AddFileToList(pFile,nIndex);
		pFile=pFile->m_pNextFile;
		nIndex++;
	}
	
}

int CFATXPlorerDlg::AddFileToList(CFATXFile * pFile, int nIndex)
{
	if(!pFile) return 0;
	BYTE strName[41];
	ZeroMemory(strName,41);
	memcpy(strName,pFile->m_deInfo.byteFileName,40);
	strName[pFile->m_deInfo.byteSizeOfFilename]=0;

	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));

	item.mask=LVIF_PARAM|LVIF_TEXT;
	item.pszText=(LPSTR)strName;
	item.lParam=(LPARAM)pFile;
	item.iSubItem=0;
	item.iItem=nIndex;
	m_lcFiles.InsertItem(&item);

	sprintf((char*)strName,"%li",pFile->m_deInfo.dwFileSize);

	item.mask=LVIF_TEXT;
	item.pszText=(LPSTR)(strName);
	item.lParam=NULL;
	item.iSubItem=1;
	item.iItem=nIndex;

	m_lcFiles.SetItem(&item);

	return 0;
}

BOOL CFATXPlorerDlg::DestroyWindow()
{
	return CDialog::DestroyWindow();
}

void CFATXPlorerDlg::OnBnClickedButton2()
{
	int nItem=m_lcFiles.GetSelectionMark();
	if(nItem==-1)
	{
		MessageBox("No File Selected","ERROR");
		return;
	}

	CFATXFile *pFile = (CFATXFile*)(m_lcFiles.GetItemData(nItem));


	OPENFILENAME Ofn;       // common dialog box structure
	char szFile[260];       // buffer for file name
	ZeroMemory(szFile,260);
	HWND hwnd=GetSafeHwnd();              // owner window

// Initialize OPENFILENAME
	ZeroMemory(&Ofn, sizeof(OPENFILENAME));
	Ofn.lStructSize = sizeof(OPENFILENAME); 
	Ofn.hwndOwner = hwnd; 
	Ofn.lpstrFilter = NULL; 
	Ofn.lpstrFile= szFile; 
	Ofn.nMaxFile = sizeof(szFile); 
	Ofn.lpstrFileTitle = NULL; 
	Ofn.nMaxFileTitle = NULL; 
	Ofn.lpstrInitialDir = (LPSTR)NULL; 
	Ofn.Flags = OFN_OVERWRITEPROMPT; 
	Ofn.lpstrTitle = NULL; 


// Display the Open dialog box. 

	if (GetSaveFileName(&Ofn)==NULL)
	{	
		return;
	}

	CFile file(Ofn.lpstrFile,CFile::modeCreate | CFile::modeWrite);
	DWORD nCtr=0;
	BYTE Data[16384];
	ZeroMemory(Data,16384);

	pFile->SetFilePointer(0);

	DWORD dwBytesToRead=16384;

	while(nCtr<pFile->m_deInfo.dwFileSize)
	{
		if(dwBytesToRead>(pFile->m_deInfo.dwFileSize-nCtr))
			dwBytesToRead=(pFile->m_deInfo.dwFileSize-nCtr);

		if(!m_FATXDisk.ReadFATXFile(pFile,&Data,dwBytesToRead))
		{
			MessageBox("Error reading file");
			break;
		}
		file.Write(&Data,dwBytesToRead);
		nCtr+=16384;
	}

	file.Flush();
	file.Close();

	MessageBox("File OK");
	
}

void CFATXPlorerDlg::OnBnClickedButtonDelete()
{
	int nItem=m_lcFiles.GetSelectionMark();
	if(nItem==-1)
	{
		MessageBox("No File Selected","ERROR");
		return;
	}

	CFATXFile *pFile = (CFATXFile*)(m_lcFiles.GetItemData(nItem));
	
	m_FATXDisk.DeleteFATXFile(pFile);

	m_bDelete=TRUE;
	m_lcFiles.DeleteAllItems();
	m_ctrlFileView.DeleteAllItems();

	m_bDelete=FALSE;
	RedrawList();

}

void CFATXPlorerDlg::OnBnClickedButtonAdd()
{
	OPENFILENAME ofn;       // common dialog box structure
	char szFile[260];       // buffer for file name
	ZeroMemory(szFile,260);
	HWND hwnd=GetSafeHwnd();              // owner window

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = NULL;
	ofn.nFilterIndex = 0;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	// Display the Open dialog box. 

	if (GetOpenFileName(&ofn)==NULL) 
	{
		return;
	}

	CString strFile=ofn.lpstrFile;
	int nIndex=strFile.GetLength()-(strFile.ReverseFind('\\')+1);
	strFile=strFile.Right(nIndex);

	HTREEITEM item = m_ctrlFileView.GetSelectedItem();
	if (!item) return;
	CFATXDirectory *pDir=((CFATXDirectory*)(m_ctrlFileView.GetItemData(item)));
	if(!pDir) 	return;

	CFATXFile *pFile=m_FATXDisk.AddFATXFile(pDir,(char*)((LPCTSTR)strFile));

	CFile file(ofn.lpstrFile,CFile::modeRead);
	ULONGLONG nCtr=0;

	pFile->SetFilePointer(0);
	ULONGLONG ullSize=file.GetLength();

	BYTE Data[16384];
	ZeroMemory(Data,16384);
	DWORD dwBytesToRead=16384;

	while(nCtr<ullSize)
	{
		if(dwBytesToRead>(ullSize-nCtr))
			dwBytesToRead=(DWORD)(ullSize-nCtr);

		TRACE("\nWriting %i / %i",nCtr,ullSize);
		if(file.Read(&Data,dwBytesToRead))
		{
			if(!m_FATXDisk.WriteFATXFile(pFile,&Data,dwBytesToRead))
			{
				break;
			}
		}
		else
		{
			break;
		}
		nCtr+=dwBytesToRead;
	}

	file.Close();

	delete pFile;

	m_bDelete=TRUE;
	m_lcFiles.DeleteAllItems();
	m_ctrlFileView.DeleteAllItems();
	m_bDelete=FALSE;
	m_FATXDisk.Clear();
	m_FATXDisk.ReadDirectoryEntries();
	RedrawList();
}

void CFATXPlorerDlg::OnBnClickedButtonAdddir()
{
	char *strName[40];
	ZeroMemory(strName,40);
	GetDlgItemText(IDC_EDIT_DIRECTORY,(char*)strName,40);

	if(strName[0]==0)
	{
		MessageBox("Enter Directoryname");
		return;
	}
	
	HTREEITEM item = m_ctrlFileView.GetSelectedItem();
	if (!item) return;
	CFATXDirectory *pDir=((CFATXDirectory*)(m_ctrlFileView.GetItemData(item)));
	if(!pDir) 	return;

	m_FATXDisk.AddDirectory((char*)strName,pDir);

	m_bDelete=TRUE;
	m_lcFiles.DeleteAllItems();
	m_ctrlFileView.DeleteAllItems();
	m_bDelete=FALSE;
	m_FATXDisk.Clear();
	m_FATXDisk.ReadDirectoryEntries();
	RedrawList();
}

void CFATXPlorerDlg::OnBnClickedButton3()
{
	int i=0;

	while(i<256)
	{
		CString strDriveName="";
		strDriveName.Format("\\\\.\\PHYSICALDRIVE%i",i);
		TRACE("\n%s",strDriveName);

		if (!m_FATXDisk.InitInstance(strDriveName))
		{
			CString strMessage;
			strMessage.Format("XBOX Harddrive found at %s",strDriveName);
			MessageBox(strMessage);
			m_FATXDisk.Clear();
			m_FATXDisk.ReadDirectoryEntries();
			RedrawList();
			return;
		}

		i++;
	}

	MessageBox("No XBOX Harddrive found (still locked ?)","ERROR");

}

void CFATXPlorerDlg::OnBnClickedButton4()
{
	CAboutDlg about;
	about.DoModal();
}
