#include "StdAfx.h"
#include "fatxdisk.h"

CFATXDisk::CFATXDisk(void)
{
	hDevice=0;               // handle to the drive to be examined 
	m_pPartitions = new CFATXPartition[5];
	Clear();
}

CFATXDisk::~CFATXDisk(void)
{
	Clear();
	if(m_pPartitions)
	{
		delete[] m_pPartitions;
		m_pPartitions=NULL;
	}
}

int CFATXDisk::InitInstance(CString strDiskName)
{
	if(strDiskName=="") return 1;
	Clear();

	if(hDevice)
	{
		CloseHandle(hDevice);
		hDevice=0;               // handle to the drive to be examined 
	}

	hDevice = CreateFile(strDiskName,//"\\\\.\\PHYSICALDRIVE2", // drive to open
						GENERIC_WRITE | GENERIC_READ,
						0,  // share mode
						NULL,    // default security attributes
						OPEN_EXISTING,  // disposition
						0,       // file attributes
						NULL);   // don't copy any file's attributes


	if (hDevice == INVALID_HANDLE_VALUE) // we can't open the drive
	{
		TRACE("\nFileOpen FAILED !");
		hDevice=0;
		return 1;
	}

	TRACE("\nFileOpen OK !");

	BYTE Buffer[4];
	ZeroMemory(Buffer,4);

	DWORD dwTemp=ReadFATXData(0x0600,Buffer,4);

	if (!dwTemp) 
	{ 
		DWORD dwError=GetLastError();
		TRACE("\nError: %li",dwError);
		CloseHandle(hDevice);
		hDevice=0;
		return 1;
	}
	if(Buffer[0]!='B' || Buffer[1]!='R' || Buffer[2]!='F' || Buffer[3]!='R')
	{
		TRACE("\nNo XBOX Harddisk");
		CloseHandle(hDevice);
		hDevice=0;
		return 1;
	}

	return 0;
}

int CFATXDisk::ExitInstance(void)
{
	CloseHandle(hDevice);
	Clear();
	return 0;
}

int CFATXDisk::GetNumberOfPartitions(void)
{
	return 5;
}

CFATXPartition * CFATXDisk::GetPartition(int nPartition)
{
	if(nPartition<0 || nPartition>4)
		return NULL;

	return &(m_pPartitions[nPartition]);
}

int CFATXDisk::Clear(void)
{
	ZeroMemory(&m_ConfigTable,sizeof(FATX_DISCCONFIGTABLE));

	for (int i=0;i < 5;i++)
	{
		m_pPartitions[i].Clear();
	}

	return 0;
}

int CFATXDisk::ReadPartition(CFATXPartition & Partition)
{
	LONG Offset2=0;
	DWORD dwByteReadIn=sizeof(FATX_PARTITIONHEADER);
	DWORD dwByteReadOut=0;

	dwByteReadOut=ReadFATXData(Partition.m_dwOffset,
		&(Partition.m_PartitionHeader),
		dwByteReadIn);



	Partition.m_pRootDirectory= new CFATXDirectory();
	Partition.m_pRootDirectory->m_fftFATType=Partition.m_fftFATType;
	Partition.m_pRootDirectory->m_dwOffsetData=Partition.m_dwOffset+Partition.m_dwClusterChainSize+0x00001000;
	Partition.m_pRootDirectory->m_dwStartAddress=Partition.m_dwOffset+Partition.m_dwClusterChainSize+0x00001000;
	Partition.m_pRootDirectory->m_dwOffsetClusterChain=Partition.m_dwOffset+0x00001000;


	ReadDirectory(Partition.m_pRootDirectory,
		Partition.m_dwOffset+0x00001000,
		Partition.m_dwOffset+Partition.m_dwClusterChainSize+0x00001000,
		Partition.m_fftFATType);

	return 0;
}

int CFATXDisk::ReadDirectory(CFATXDirectory * pDirectory, DWORD dwOffsetClusterChain, DWORD dwOffsetCluster, FATX_FAT_TYPE fftFATType)
{
	DWORD dwOffset=0;
	if (pDirectory->m_deInfo.dwFirstCluster)
		dwOffset=(pDirectory->m_deInfo.dwFirstCluster-1)*16384;
	BYTE Data[16384];
	FATX_DIRECTORYENTRIES Info;
	ZeroMemory(&Info,sizeof(FATX_DIRECTORYENTRIES)) ;
	DWORD dwCurrentBufferOffset=0;

	BOOL bReadNextCluster=FALSE;

	CFATXDirectory * pTempDir =NULL;
	CFATXFile * pTempFile =NULL;

	do
	{
		dwCurrentBufferOffset=0;
		ReadCluster(Data,dwOffset+dwOffsetCluster);
	
		BOOL bSearchBuffer=FALSE;
		
		do
		{
			memcpy(&Info,&(Data[dwCurrentBufferOffset]),sizeof(FATX_DIRECTORYENTRIES));
			if(Info.byteSizeOfFilename==0xFF || 
				((dwCurrentBufferOffset+sizeof(FATX_DIRECTORYENTRIES))>16384)
				)
			{
				bSearchBuffer=FALSE;
			}
			else
			{
				bSearchBuffer=TRUE;

				if (Info.byteAttribute&FILE_ATTRIBUTE_DIRECTORY)
				{ // is a directory
					pTempDir = new  CFATXDirectory();
					memcpy(&(pTempDir->m_deInfo),&Info,sizeof(FATX_DIRECTORYENTRIES));
					pTempDir->m_dwOffsetData=dwOffsetCluster;
					pTempDir->m_dwOffsetClusterChain=dwOffsetClusterChain;
					pTempDir->m_fftFATType=fftFATType;
					pTempDir->m_dwStartAddress=dwOffsetCluster+(pTempDir->m_deInfo.dwFirstCluster-1)*16384;
					ReadDirectory(pTempDir,dwOffsetClusterChain,dwOffsetCluster,fftFATType);
					if(!pDirectory->m_pDirChild)
					{
						pDirectory->m_pDirChild=pTempDir;
					}
					else
					{
						pDirectory->m_pDirChild->AddDir(pTempDir);
					}
				}
				else
				{ // is a file
					if(Info.byteSizeOfFilename!=0xE5) // Deleted File
					{
						pTempFile = new  CFATXFile();
						memcpy(&(pTempFile->m_deInfo),&Info,sizeof(FATX_DIRECTORYENTRIES));
						
						pTempFile->m_pParent=pDirectory;
						pTempFile->m_fftFATType=fftFATType;
						pTempFile->m_dwStartAddress=dwOffset+dwOffsetCluster+dwCurrentBufferOffset;
						//pTempFile->m_dwStartAddress=dwOffsetCluster+(pTempFile->m_deInfo.dwFirstCluster-1)*16384;
						pTempFile->m_dwOffsetData=dwOffsetCluster;
						pTempFile->m_dwOffsetClusterChain=dwOffsetClusterChain;
						pDirectory->AddFile(pTempFile);
					}
				}
			}

			dwCurrentBufferOffset+=sizeof(FATX_DIRECTORYENTRIES);
		} while(bSearchBuffer);

	} while(bReadNextCluster);


	return 0;
}

int CFATXDisk::ReadCluster(void * pBuffer, DWORD dwOffset)
{
	DWORD dwRead=0;
	LONG Offset2=0;

	SetFilePointer(hDevice,dwOffset,&Offset2,FILE_BEGIN);
	ReadFile(hDevice,pBuffer,16384,&dwRead,NULL);

	if(dwRead!=16384)
		return 1;

	return 0;
}

int CFATXDisk::ReadDirectoryEntries(void)
{
	Clear();

	DWORD dwByteReadIn=0;
	DWORD dwByteReadOut=0;
	LONG Offset2=0;

	dwByteReadOut=ReadFATXData(FATX_POS_DISCCONFIG,&m_ConfigTable,dwByteReadIn);

TRACE("\nRead Partition 1");
	m_pPartitions[0].SetOffset(FATX_POS_CACHE1);
	m_pPartitions[0].SetPartitionType(FATX_FPT_CACHE);
	ReadPartition(m_pPartitions[0]);

TRACE("\nRead Partition 2");
	m_pPartitions[1].SetOffset(FATX_POS_CACHE2);
	m_pPartitions[1].SetPartitionType(FATX_FPT_CACHE);
	ReadPartition(m_pPartitions[1]);

TRACE("\nRead Partition 3");
	m_pPartitions[2].SetOffset(FATX_POS_CACHE3);
	m_pPartitions[2].SetPartitionType(FATX_FPT_CACHE);
	ReadPartition(m_pPartitions[2]);

TRACE("\nRead Partition 4");
	m_pPartitions[3].SetOffset(FATX_POS_SYSTEM);
	m_pPartitions[3].SetPartitionType(FATX_FPT_SYSTEM);
	ReadPartition(m_pPartitions[3]);

TRACE("\nRead Partition 5");
	m_pPartitions[4].SetOffset(FATX_POS_DATA);
	m_pPartitions[4].SetPartitionType(FATX_FPT_DATA);
	ReadPartition(m_pPartitions[4]);


	return 0;
}

DWORD CFATXDisk::ReadFATXFile(CFATXFile * pFile, void * pBuffer, DWORD dwSize)
{

	if(!pBuffer || !dwSize) return 0;
	if(pFile->m_dwPointer==0xffffffff) return 0;


	DWORD dwChunk=0;
	DWORD dwCounter=0;
	DWORD dwClusterSize=0;

	if(pFile->m_fftFATType==FATX_FFT_FATX16)
		dwClusterSize=2;
	if(pFile->m_fftFATType==FATX_FFT_FATX32)
		dwClusterSize=4;

	dwChunk=(pFile->m_dwPointer/16384);

	if(pFile->m_dwPointer==0)
		dwChunk=0;

	dwCounter=pFile->m_dwPointer%16384;

	DWORD dwTargetCluster=pFile->m_deInfo.dwFirstCluster;


	DWORD dwActualCluster=0;

	// find first cluster to write
	while(dwActualCluster<dwChunk)
	{
		DWORD dwNext=0;

		ReadFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
				&dwNext,dwClusterSize);

		BOOL bTrue=FALSE;
		if(dwClusterSize==2 && dwNext==0xFFFF)
			bTrue=TRUE;
		if(dwClusterSize==4 && dwNext==0xFFFFFFFF)
			bTrue=TRUE;

		DWORD dwNewCluster=0;

		if(bTrue) // Last Cluster
		{
			return 0;
		}
		else
		{
			dwTargetCluster=dwNext;
		}

		dwActualCluster++;
	}

	DWORD dwCurrentOffset=pFile->m_dwOffsetData+((dwTargetCluster-1)*16384)+dwCounter;

	DWORD dwNumBytesToRead=dwSize;
	DWORD dwBytesRead=0;

	while(dwBytesRead<dwSize)
	{
		dwNumBytesToRead=dwSize-dwBytesRead;
		if(dwNumBytesToRead>(16384-dwCounter))
			dwNumBytesToRead=(16384-dwCounter);

		ReadFATXData(dwCurrentOffset,((BYTE*)pBuffer+dwCounter),dwNumBytesToRead);

		dwCounter+=dwNumBytesToRead;
		dwBytesRead+=dwNumBytesToRead;
		dwCurrentOffset+=dwNumBytesToRead;

		if(dwCounter>=16384) // Set next cluster
		{
			DWORD dwNext=0;
			ReadFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
				&dwNext,dwClusterSize);

			BOOL bTrue=FALSE;
			if(dwSize==2 && dwNext==0xFFFF)
				bTrue=TRUE;
			if(dwSize==4 && dwNext==0xFFFFFFFF)
				bTrue=TRUE;

			DWORD dwNewCluster=0;
			if(bTrue) // Last Cluster
			{
				(pFile->m_dwPointer)+=dwBytesRead;
				return dwBytesRead;
			}

			dwTargetCluster=dwNext;
		}
	}

	(pFile->m_dwPointer)+=dwSize;
	return dwBytesRead;

return 0;
}

int CFATXDisk::DeleteFATXFile(CFATXFile * pFile)
{

	if(!pFile) return 1;

	DWORD dwZero=0x00000000;
	DWORD dwSize=0;

	if(pFile->m_fftFATType==FATX_FFT_FATX16)
	{
		dwSize=2;
	}
	if(pFile->m_fftFATType==FATX_FFT_FATX32)
	{
		dwSize=4;
	}

	DWORD dwNextChunk=pFile->m_deInfo.dwFirstCluster;
	LONG Offset2=0;
	DWORD dwNumChunkDeleted=0;

	while(dwNextChunk!=0xFFFFFFFF)
	{
		DWORD dwTmp=dwNextChunk;
		DWORD dwBytesWritten=0;
		DWORD dwByteRead=0;
		TRACE("\nDelete cluster%i ",dwNumChunkDeleted);

		
		if(dwSize==2)
		{
			WORD wData=0;
			dwByteRead=ReadFATXData(pFile->m_dwOffsetClusterChain+(dwNextChunk*dwSize),
				&wData,2);
			dwNextChunk=wData;
		}
		
		if(dwSize==4)
		{
			dwByteRead=ReadFATXData(pFile->m_dwOffsetClusterChain+(dwNextChunk*dwSize),
				&dwNextChunk,4);
		}
		
		dwBytesWritten=WriteFATXData(pFile->m_dwOffsetClusterChain+(dwTmp*dwSize),
			&dwZero,dwSize);

		if(dwNextChunk==0xFFFF && dwSize==2) dwNextChunk=0xFFFFFFFF;
		dwNumChunkDeleted++;
		TRACE("OK");


	}

	BYTE Deleted=0xE5;
	DWORD dwBytesWritten;

	dwBytesWritten=WriteFATXData(pFile->m_dwStartAddress,
		&Deleted,1);

	ReadDirectoryEntries();

	return 0;
}

int CFATXDisk::AddDirectory(char * strName, CFATXDirectory * pDir)
{

	FATX_DIRECTORYENTRIES dir;
	FATX_DIRECTORYENTRIES dirTmp;
	ZeroMemory(&dir,sizeof(FATX_DIRECTORYENTRIES));
	ZeroMemory(&dirTmp,sizeof(FATX_DIRECTORYENTRIES));

	dir.byteSizeOfFilename=(BYTE)strlen(strName);
	memcpy(&(dir.byteFileName),strName,40);
	dir.byteAttribute=0x10;
	BYTE pZero[16384];
	memset(pZero,0xFF,16384);

	// find cluster & set flag

	DWORD dwCtr=0;
	LONG Offset2=0;
	DWORD dwFFFF=0xFFFFFFFF;
		DWORD dwRead=0;
	if(pDir->m_fftFATType==FATX_FFT_FATX16)
	{
		DWORD dwCurrentOffset=pDir->m_dwOffsetClusterChain;
		WORD wData=0xFFFF;
		while(dwCtr<0xFFFF && wData!=0x0000)
		{
			dwRead=ReadFATXData(dwCurrentOffset,
				&wData,2);
			dwCurrentOffset+=2;
			dwCtr++;
		}

		dwCtr--;

		WriteFATXData(pDir->m_dwOffsetClusterChain+(dwCtr*2),
			&dwFFFF,2);
		dir.dwFirstCluster=dwCtr;
	}

	if(pDir->m_fftFATType==FATX_FFT_FATX32)
	{
		DWORD wData=0xFFFFFFFF;
		DWORD dwCurrentOffset=pDir->m_dwOffsetClusterChain;
		while(dwCtr<0xFFFFFFFF && wData!=0x00000000)
		{
			ReadFATXData(dwCurrentOffset,
				&wData,4);
			dwCurrentOffset+=4;
			dwCtr++;
		}

		dwCtr--;

		WriteFATXData(pDir->m_dwOffsetClusterChain+(dwCtr*4),
			&dwFFFF,4);
		dir.dwFirstCluster=dwCtr;
	}

	WriteFATXData(pDir->m_dwOffsetData+(dir.dwFirstCluster-1)*16384,
		pZero,16384);

	// find pos in parentcluster

	DWORD dwCurrentOffset=pDir->m_dwStartAddress;
	while(dirTmp.byteSizeOfFilename != 0xE5 && dirTmp.byteSizeOfFilename != 0xFF)
	{
		ReadFATXData(dwCurrentOffset,
			&dirTmp,sizeof(FATX_DIRECTORYENTRIES));
		dwCurrentOffset+=sizeof(FATX_DIRECTORYENTRIES);
	}
	dwCurrentOffset-=sizeof(FATX_DIRECTORYENTRIES);
	
	WriteFATXData(dwCurrentOffset,&dir,sizeof(FATX_DIRECTORYENTRIES));

	if(dirTmp.byteSizeOfFilename!=0xE5)
		WriteFATXData(dwCurrentOffset+sizeof(FATX_DIRECTORYENTRIES),&dwFFFF,1);

	return 0;
}

CFATXFile * CFATXDisk::AddFATXFile(CFATXDirectory * pDir, char * strName)
{

	FATX_DIRECTORYENTRIES dir;
	FATX_DIRECTORYENTRIES dirTmp;
	ZeroMemory(&dir,sizeof(FATX_DIRECTORYENTRIES));
	ZeroMemory(&dirTmp,sizeof(FATX_DIRECTORYENTRIES));

	CFATXFile *pFile=new CFATXFile();

	dir.byteSizeOfFilename=(BYTE)strlen(strName);
	memcpy(&(dir.byteFileName),strName,40);
	dir.byteAttribute=0x00;
	BYTE pZero[16384];
	memset(pZero,0xFF,16384);

	// find cluster & set flag

	DWORD dwCtr=0;
	LONG Offset2=0;
	DWORD dwFFFF=0xFFFFFFFF;
		DWORD dwRead=0;
	if(pDir->m_fftFATType==FATX_FFT_FATX16)
	{
		WORD wData=0xFFFF;
		DWORD dwCurrentOffset=pDir->m_dwOffsetClusterChain;
		while(dwCtr<0xFFFF && wData!=0x0000)
		{
			ReadFATXData(dwCurrentOffset,
				&wData,2);
			dwCurrentOffset+=2;
			dwCtr++;
		}

		dwCtr--;

		WriteFATXData(pDir->m_dwOffsetClusterChain+(dwCtr*2),
			&dwFFFF,2);
		dir.dwFirstCluster=dwCtr;
	}

	if(pDir->m_fftFATType==FATX_FFT_FATX32)
	{
		DWORD wData=0xFFFFFFFF;
		DWORD dwCurrentOffset=pDir->m_dwOffsetClusterChain;
		while(dwCtr<0xFFFFFFFF && wData!=0x00000000)
		{
			ReadFATXData(dwCurrentOffset,
				&wData,4);
			dwCurrentOffset+=4;
			dwCtr++;
		}

		dwCtr--;

		WriteFATXData(pDir->m_dwOffsetClusterChain+(dwCtr*4),
			&dwFFFF,4);
		dir.dwFirstCluster=dwCtr;
	}

	WriteFATXData(pDir->m_dwOffsetData+(dir.dwFirstCluster-1)*16384,
		pZero,16384);

	// find pos in parentcluster


	BYTE pBufferTmp[16384];
	ReadFATXData(pDir->m_dwStartAddress,pBufferTmp,16384);

	DWORD dwFileStart=0;
	while(dirTmp.byteSizeOfFilename != 0xE5 && dirTmp.byteSizeOfFilename != 0xFF)
	{
		memcpy(&dirTmp,&(pBufferTmp[dwFileStart]),sizeof(FATX_DIRECTORYENTRIES));
		dwFileStart+=sizeof(FATX_DIRECTORYENTRIES);
	}
	dwFileStart-=sizeof(FATX_DIRECTORYENTRIES);
	pFile->m_dwStartAddress=pDir->m_dwStartAddress+dwFileStart;

	WriteFATXData(pFile->m_dwStartAddress,&dir,sizeof(FATX_DIRECTORYENTRIES));

	if(dirTmp.byteSizeOfFilename != 0xE5)
		WriteFATXData(pFile->m_dwStartAddress+sizeof(FATX_DIRECTORYENTRIES),&dwFFFF,1);

	memcpy(&(pFile->m_deInfo),&dir,sizeof(FATX_DIRECTORYENTRIES));
	pFile->m_dwOffsetClusterChain=pDir->m_dwOffsetClusterChain;
	pFile->m_dwOffsetData=pDir->m_dwOffsetData;
	pFile->m_fftFATType=pDir->m_fftFATType;

	return pFile;

	return NULL;
}

int CFATXDisk::WriteFATXFile(CFATXFile * pFile, void * pBuffer, DWORD dwSize)
{

	if(!pBuffer || !dwSize) return 0;
	if(pFile->m_dwPointer==0xffffffff) return 0;

	// find first chunk to write

	BYTE Data[16384];
	ZeroMemory(Data,16384);
	DWORD dwChunk=0;
	DWORD dwCounter=0;
	DWORD dwByteRead=0;
	DWORD dwFFFF=0xFFFFFFFF;
	DWORD dwClusterSize=0;
	DWORD dwRead=0;
	LONG Offset2=0;
	DWORD dwTargetCluster=0;
	DWORD dwBytesWritten=0;

	dwChunk=(pFile->m_dwPointer/16384);

	if(pFile->m_dwPointer==0)
	{
		dwChunk=0;
	}

	dwCounter=pFile->m_dwPointer%16384;


	if(pFile->m_fftFATType==FATX_FFT_FATX16)
		dwClusterSize=2;
	if(pFile->m_fftFATType==FATX_FFT_FATX32)
		dwClusterSize=4;

	// make sure, that a startcluster exist
	if(pFile->m_deInfo.dwFirstCluster==0)
	{
		DWORD dwFirstCluster=0;

		dwFirstCluster=GetFreeCluster(pFile->m_dwOffsetClusterChain,dwClusterSize);

		WriteFATXData(pFile->m_dwOffsetClusterChain+(dwFirstCluster*dwClusterSize),
			&dwFFFF,dwClusterSize);

		pFile->m_deInfo.dwFirstCluster=dwFirstCluster;
	}

	dwTargetCluster=pFile->m_deInfo.dwFirstCluster;

	DWORD dwActualCluster=0;

	// find first cluster to write
	while(dwActualCluster<dwChunk)
	{
		DWORD dwNext=0;

		ReadFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
				&dwNext,dwClusterSize);

		BOOL bTrue=FALSE;
		if(dwClusterSize==2 && dwNext==0xFFFF)
			bTrue=TRUE;
		if(dwClusterSize==4 && dwNext==0xFFFFFFFF)
			bTrue=TRUE;

		DWORD dwNewCluster=0;

		if(bTrue) // Last Cluster
		{ // find a new cluster
			dwNewCluster=GetFreeCluster(pFile->m_dwOffsetClusterChain,dwClusterSize);
			WriteFATXData(pFile->m_dwOffsetClusterChain+(dwNewCluster*dwClusterSize),
				&dwFFFF,dwClusterSize);

			if(dwClusterSize==2)
			{
				WORD dwPos=(WORD)dwNewCluster;
				WriteFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
					&dwPos,dwClusterSize);
			}
			if(dwClusterSize==4)
			{
				DWORD dwPos=dwNewCluster;
				WriteFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
					&dwPos,dwClusterSize);
			}

			dwTargetCluster=dwNewCluster;
		}
		else
		{
			dwTargetCluster=dwNext;
		}

		dwActualCluster++;
	}




	DWORD dwCurrentOffset=pFile->m_dwOffsetData+((dwTargetCluster-1)*16384)+dwCounter;

	DWORD dwNumBytesToWrite=dwSize;

	while(dwBytesWritten<dwSize)
	{
		dwNumBytesToWrite=dwSize-dwBytesWritten;
		if(dwNumBytesToWrite>(16384-dwCounter))
			dwNumBytesToWrite=(16384-dwCounter);

		WriteFATXData(dwCurrentOffset,((BYTE*)pBuffer+dwCounter),dwNumBytesToWrite);

		dwCounter+=dwNumBytesToWrite;
		dwBytesWritten+=dwNumBytesToWrite;
		dwCurrentOffset+=dwNumBytesToWrite;

		if(dwCounter>=16384) // Set next cluster
		{
			DWORD dwNext=0;
			ReadFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
				&dwNext,dwClusterSize);

			BOOL bTrue=FALSE;
			if(dwSize==2 && dwNext==0xFFFF)
				bTrue=TRUE;
			if(dwSize==4 && dwNext==0xFFFFFFFF)
				bTrue=TRUE;

			DWORD dwNewCluster=0;
			if(bTrue) // Last Cluster
			{ // find a new cluster
				dwNewCluster=GetFreeCluster(pFile->m_dwOffsetClusterChain,dwClusterSize);
				WriteFATXData(pFile->m_dwOffsetClusterChain+(dwNewCluster*dwClusterSize),
					&dwFFFF,dwClusterSize);

				if(dwSize==2)
				{
					WORD dwPos=(WORD)dwNewCluster;
					WriteFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
						&dwPos,dwClusterSize);
				}
				if(dwSize==4)
				{
					DWORD dwPos=dwNewCluster;
					WriteFATXData(pFile->m_dwOffsetClusterChain+(dwTargetCluster*dwClusterSize),
						&dwPos,dwClusterSize);
				}

			}

			dwTargetCluster=dwNext;
		}
	}

	(pFile->m_dwPointer)+=dwSize;

	if(pFile->m_dwPointer>pFile->m_deInfo.dwFileSize)
	{
		pFile->m_deInfo.dwFileSize=pFile->m_dwPointer;
		WriteFATXData(pFile->m_dwStartAddress,
			&(pFile->m_deInfo),sizeof(FATX_DIRECTORYENTRIES));

	}

	return dwBytesWritten;

return 0;
}

DWORD CFATXDisk::GetFreeCluster(DWORD dwOffset, DWORD dwSize)
{
	// find cluster & set flag

	DWORD dwCtr=0;
	LONG Offset2=0;
	DWORD dwRead=0;

	if(dwSize==2)
	{
		DWORD dwCurrentOffset=dwOffset;
		WORD wData=0xFFFF;
		while(dwCtr<0xFFFF && wData!=0x0000)
		{
			ReadFATXData(dwCurrentOffset,&wData,2);
			dwCurrentOffset+=2;
			dwCtr++;
		}
		if(dwCtr==0xFFFF)
			return NULL;
		dwCtr--;
	}

	if(dwSize==4)
	{
		DWORD dwCurrentOffset=dwOffset;
		DWORD wData=0xFFFFFFFF;
		while(dwCtr<0xFFFFFFFF && wData!=0x00000000)
		{
			ReadFATXData(dwCurrentOffset,&wData,4);
			dwCurrentOffset+=4;
			dwCtr++;
		}
		if(dwCtr==0xFFFFFFFF)
			return NULL;
		dwCtr--;
	}

	return dwCtr;
}

DWORD CFATXDisk::ReadFATXData(DWORD dwOffset, void * pBuffer, DWORD dwSize)
{
	if(!pBuffer || !dwSize || !hDevice)
		return 0;

	DWORD dwOffsetDiff=dwOffset%FATX_CLUSTERSIZE;
	DWORD dwBufferSize=(((dwOffsetDiff+dwSize)/FATX_CLUSTERSIZE)+1)*FATX_CLUSTERSIZE;

	LONG Offset2=0;
	DWORD dwByteReadOut=0;
	void *pTempBuffer = new BYTE[dwBufferSize];

	DWORD dwTemp1=SetFilePointer(hDevice,dwOffset-dwOffsetDiff,&Offset2,FILE_BEGIN);
	DWORD dwTemp2=ReadFile(hDevice,pTempBuffer,dwBufferSize,&dwByteReadOut,NULL);

	if((dwByteReadOut!=dwBufferSize) || !dwTemp2)
	{
		TRACE("\nReadERROR");
		return 0;
	}

	memcpy(pBuffer,(BYTE*)pTempBuffer+dwOffsetDiff,dwSize);
	delete [] pTempBuffer;

	return dwSize;
}

DWORD CFATXDisk::WriteFATXData(DWORD dwOffset, void * pBuffer, DWORD dwSize)
{
	if(!pBuffer || !dwSize || !hDevice)
		return 0;

	DWORD dwOffsetDiff=dwOffset%FATX_CLUSTERSIZE;

	DWORD dwBufferSize=
		((((dwOffsetDiff+dwSize)/FATX_CLUSTERSIZE)+1)*FATX_CLUSTERSIZE);

	LONG Offset2=0;
	DWORD dwByteReadOut=0;
	void *pTempBuffer = new BYTE[dwBufferSize];

	DWORD dwTemp1=SetFilePointer(hDevice,(dwOffset-dwOffsetDiff),&Offset2,FILE_BEGIN);
	DWORD dwTemp2=ReadFile(hDevice,pTempBuffer,dwBufferSize,&dwByteReadOut,NULL);

	if((dwByteReadOut!=dwBufferSize) || !dwTemp2)
	{
		TRACE("\nReadERROR");
		return 0;
	}

	memcpy(((BYTE*)pTempBuffer)+dwOffsetDiff,pBuffer,dwSize);

	dwTemp1=SetFilePointer(hDevice,(dwOffset-dwOffsetDiff),&Offset2,FILE_BEGIN);
	dwTemp2=WriteFile(hDevice,pTempBuffer,dwBufferSize,&dwByteReadOut,NULL);

	if((dwByteReadOut!=dwBufferSize) || !dwTemp2)
	{
		TRACE("\nWriteERROR");
		return 0;
	}

	delete [] pTempBuffer;

	return dwSize;
}
