#pragma once

#include "fatxpartition.h"

class CFATXDisk
{
public:
	CFATXDisk(void);
	~CFATXDisk(void);
	int InitInstance(CString strDiskName="");
	int ExitInstance(void);
	int GetNumberOfPartitions(void);
	CFATXPartition * GetPartition(int nPartition);

	HANDLE hDevice;               // handle to the drive to be examined 



	FATX_DISCCONFIGTABLE	m_ConfigTable;

	CFATXPartition	*m_pPartitions;

	int Clear(void);
	int ReadPartition(CFATXPartition & Partition);
	int ReadDirectory(CFATXDirectory * pDirectory, DWORD dwOffsetClusterChain, DWORD dwOffsetCluster, FATX_FAT_TYPE fftFATType);
	int ReadCluster(void * pBuffer, DWORD dwOffset);
	int ReadDirectoryEntries(void);
	DWORD ReadFATXFile(CFATXFile * pFile, void * pBuffer, DWORD dwSize);
	int DeleteFATXFile(CFATXFile * pFile);
	int AddDirectory(char * strName, CFATXDirectory * pDir);
	int WriteFATXFile(CFATXFile * pFile, void * pBuffer, DWORD dwSize);
	CFATXFile * AddFATXFile(CFATXDirectory * pDir, char * strName);
	DWORD GetFreeCluster(DWORD dwOffset, DWORD dwSize);
	DWORD ReadFATXData(DWORD dwOffset, void * pBuffer, DWORD dwSize);
	DWORD WriteFATXData(DWORD dwOffset, void * pBuffer, DWORD dwSize);
};
