#include "StdAfx.h"
#include "fatxpartition.h"

CFATXPartition::CFATXPartition(void)
{
	ZeroMemory(&m_PartitionHeader,sizeof(FATX_PARTITIONHEADER));
	m_fftFATType=FATX_FFT_UNKNOWN;
	m_dwClusterChainSize=0;
	m_fptPartitionType=FATX_FPT_UNKNOWN;
	m_dwOffset=0;
	m_pRootDirectory=NULL;
}

CFATXPartition::~CFATXPartition(void)
{
}

int CFATXPartition::SetPartitionType(FATX_PARTITION_TYPE fptType)
{
	m_fptPartitionType=fptType;

	switch(fptType)
	{
		case FATX_FPT_CACHE:
			m_fftFATType=FATX_FFT_FATX16;
			m_dwClusterChainSize=FATX_CHAINSIZE_CACHE;
		break;
		case FATX_FPT_SYSTEM:
			m_fftFATType=FATX_FFT_FATX16;
			m_dwClusterChainSize=FATX_CHAINSIZE_SYSTEM;
		break;
		case FATX_FPT_DATA:
			m_fftFATType=FATX_FFT_FATX32;
			m_dwClusterChainSize=FATX_CHAINSIZE_DATA;
		break;
		default:
			m_fftFATType=FATX_FFT_UNKNOWN;
			m_fptPartitionType=FATX_FPT_UNKNOWN;
			m_dwClusterChainSize=0;
		break;
	};
	return 0;
}

int CFATXPartition::Clear(void)
{
	if(m_pRootDirectory)
	{
		delete m_pRootDirectory;
		m_pRootDirectory=NULL;
	}

	return 0;
}

int CFATXPartition::SetOffset(DWORD Offset)
{
	m_dwOffset=Offset;
	return 0;
}
