/*............................................................................*/
/* UTILITY FUNCTIONS FOR VIPER GC VERSION 1.0 (C) BY ROMANO M. 2004           */
/*                                                                            */
/* READ THE WHOLE .H FILE CARFULLY BEFORE USING IT! THANK YOU                 */
/* NOTE: BEFORE CALLING VIPERINIT, DON'T ACCESS MEMORY AFTER 81300000, OR     */
/*       YOU MIGHT NEED TO ADD DATA CACHE INVALIDATING AFTER EXI DMA.         */
/*............................................................................*/

#include "viper.h"

#define EXI_SR                *(volatile unsigned long*) 0xCC006800
#define EXI_DMA_MEM           *(volatile unsigned long*) 0xCC006804
#define EXI_DMA_LEN           *(volatile unsigned long*) 0xCC006808
#define EXI_CR                *(volatile unsigned long*) 0xCC00680C
#define EXI_DATA              *(volatile unsigned long*) 0xCC006810
#define EXI_WAIT_EOT          while((EXI_CR)&1);    

#define VIPER_MAGIC           0x00495052 

unsigned long ViperCmdPtr[256];

void ReadIPL(unsigned char *buffer)
{
    int i;
    for (i=0;i<0x200000;i+=0x400)
    {
        EXI_SR = 0x150;   
        EXI_DATA = i<<6;
        EXI_CR = 0x35;
        EXI_WAIT_EOT;
        EXI_DMA_MEM = (int)buffer+i;
        EXI_DMA_LEN = 0x400;
        EXI_CR = 3; 
        EXI_WAIT_EOT;
        EXI_SR = 0x0;  
    }
}

void ReadVPL(unsigned char *buffer)
{
    EXI_SR = 0x040;  
    EXI_DMA_MEM = (int)buffer; 
    EXI_DMA_LEN = 0x40000;
    EXI_CR = 3; 
    EXI_WAIT_EOT;
    EXI_SR = 0;
}

unsigned char* PadVPL(unsigned char *buffer)
{
    int i;
    unsigned char *ViperBuffer = buffer+0x10104;
    int PadLen = 0x24341; 
    if (((*(unsigned long*)(buffer+0x80c))&0xffffff)==VIPER_MAGIC)
    {
        PadLen = 0x303; 
        ViperBuffer = buffer+0x80C;
    }
    if (((*(unsigned long*)(buffer+0x10204))&0xffffff)==VIPER_MAGIC) 
    {
        PadLen = 0x14281;  
        ViperBuffer = buffer+0x10204;
    }
    for (i=0;i<PadLen;i++)  // possible optimisation: use DMA instead!
    {
    	EXI_SR = 0x040;
        EXI_DATA = 0;  
    	EXI_CR = 0x35; 
    	EXI_WAIT_EOT;
    }    

    return ViperBuffer;
}

void ViperInitCmd(unsigned long *original)
{
    int i;
    for (i=0;i<256;i++) ViperCmdPtr[i]=-1;
    int left=256;
    i=0;
    while (left>0)
    {
        unsigned char ThisByte=((original[i]>>24)&0xff);
        if (ViperCmdPtr[ThisByte]==-1)
        {
            ViperCmdPtr[ThisByte]=i*4;
            left--;
        }        
        i++;
    }    
}

// Must be called before any other Viper-Related fonction. Only call it if
// FLAG_EXTENDED_MODE is set in the header
void ViperInit()
{
    int i,j;
    unsigned char *Ipl = (unsigned char*)ADDR_IPL-0x20;
    unsigned char *EncryptedIpl = (unsigned char*)ADDR_ENCRYPTED_IPL+0x800; 
    unsigned char *EncryptedSource;
    unsigned char *EncryptedDest = (unsigned char*) ADDR_VIPER_FLASH;
    
    ReadVPL((unsigned char*)ADDR_VIPER_256KB_TEMP_BUFFER);
    EncryptedSource = PadVPL((unsigned char*)ADDR_VIPER_256KB_TEMP_BUFFER);
    
    ReadIPL((void*)ADDR_ENCRYPTED_IPL);
    ViperInitCmd((void*)ADDR_ENCRYPTED_IPL);

    j=0;
    for (i=0;i<128*1024;i++)
    {
        EncryptedDest[i] = EncryptedSource[i+j];
        if ((i&0x3FF)==0x3FF)
            j+=4;
    }

    for (i=0;i<2*1024*1024;i++)
        Ipl[i]^=(EncryptedDest[i&0x1FFFF]^EncryptedIpl[i]);                
}    

// Send a command to the Viper GC
void ViperSendCmd(unsigned char cmd0, unsigned char cmd1)
{
	EXI_SR = 0x140;
	EXI_DATA = ViperCmdPtr[cmd0]<<6;
	EXI_CR = 0x35;
	EXI_WAIT_EOT;
	EXI_SR = 0x140;
	EXI_CR = 0x09; 
	EXI_WAIT_EOT;
	EXI_SR = 0x0;  
	EXI_SR = 0x140;
	EXI_DATA = ViperCmdPtr[cmd1]<<6;   
	EXI_CR = 0x35; 
	EXI_WAIT_EOT;
	EXI_SR = 0x140;
	EXI_CR = 0x09; 
	EXI_WAIT_EOT;
	EXI_SR = 0x0;  
}

// Read a byte from the Viper GC
unsigned char ViperReadByte()
{
    unsigned long result = 0;
	EXI_SR = 0x040;// chip select, 32MHz
	EXI_CR = 0x09; // start Imm read transfert
	EXI_WAIT_EOT;
	result = EXI_DATA;
	return ((result>>24)&0xff);
}

// Set LID connector status (0 = open, 1 = closed, 2 = passthru)
void ViperWriteToLid(unsigned char c)
{
    ViperSendCmd(0xd2, c);
}

// Read Switch 2 (bit 0) and Lid sensor (bit 1)
unsigned char ViperReadSwitchAndLid()
{
    ViperSendCmd(0xd3, 0);
    return ViperReadByte();
}

// Send a byte to PC (DEBUG ONLY!)
void ViperWriteToPC(unsigned char c)
{
    ViperSendCmd(0xd0, c);
}

// Read a byte from PC (DEBUG ONLY!)
unsigned char ViperReadFromPC()
{
    ViperSendCmd(0xd1, 0);
    return ViperReadByte();
}

// Below are code examples to access Viper GC Flash Memory. Be sure
// the FLAG_GC_FLASH_ACCESS is set in the VIPR header (together with
// the usual command flags).
// ViperGetFlashManufacturerID returns the Manufacturer Code of the FLash (0xBF)
// Get the datasheet of SST39VF010 for more information. Don't play with this 
// routine if you don't know what you're doing.
void ViperWriteFlashAD(unsigned long a, unsigned char d)
{
    ViperSendCmd(0xdc,a>>16);
    ViperSendCmd(0xdc,a>>8);
    ViperSendCmd(0xdc,a);
    ViperSendCmd(0xdc,d);
}

unsigned char prevdoe,prevnoe,prevnwe;
void ViperWriteFlashDOW(unsigned char doe, unsigned char noe, unsigned char nwe)
{
    prevdoe = doe;
    prevnoe = noe;
    prevnwe = nwe;
    ViperSendCmd(0xdd,(prevdoe<<2)|(prevnoe<<1)|(prevnwe<<0));
    ViperReadByte();
}

unsigned char ViperReadFlash()
{
    ViperSendCmd(0xdd,(prevdoe<<2)|(prevnoe<<1)|(prevnwe<<0));
    return ViperReadByte(); 
}

void ViperExitCommandMode()
{
    ViperSendCmd(0xff,0);
}

unsigned char ViperGetFlashManufacturerID()
{
    int ManufacturerID;
    int DeviceID;
    
    // Software ID Entry
    ViperWriteFlashAD(0x5555,0xaa);
    ViperWriteFlashDOW(1,1,1);
    ViperWriteFlashDOW(1,1,0);
    ViperWriteFlashDOW(1,1,1);    
    ViperWriteFlashAD(0x2aaa,0x55);
    ViperWriteFlashDOW(1,1,1);
    ViperWriteFlashDOW(1,1,0);
    ViperWriteFlashDOW(1,1,1);    
    ViperWriteFlashAD(0x5555,0x90);
    ViperWriteFlashDOW(1,1,1);
    ViperWriteFlashDOW(1,1,0);
    ViperWriteFlashDOW(1,1,1);
    
    // Read Manufacturer ID and Device ID
    ViperWriteFlashDOW(0,0,1);
    ViperWriteFlashAD(0,0);
    ManufacturerID=ViperReadFlash();
    ViperWriteFlashAD(1,0);
    DeviceID=ViperReadFlash();

    // Software ID Exit
    ViperWriteFlashAD(0x1234,0xf0);
    ViperWriteFlashDOW(1,1,1);
    ViperWriteFlashDOW(1,1,0);
    ViperWriteFlashDOW(1,1,1);
    
    return ManufacturerID;
}
