/*............................................................................*/
/* UTILITY FUNCTIONS FOR VIPER GC VERSION 1.0 (C) BY ROMANO M. 2004           */
/*                                                                            */
/* READ THE WHOLE FILE CARFULLY BEFORE USING IT! THANK YOU                    */
/* NOTE: BEFORE CALLING VIPERINIT, DON'T ACCESS MEMORY AFTER 81300000, OR     */
/*       YOU MIGHT NEED TO ADD DATA CACHE INVALIDATING AFTER EXI DMA.         */
/*............................................................................*/

#ifndef	__VIPER__
#define	__VIPER__

// First 4 bytes of a valid Viper GC Flash file
#define VIPER_HEADER          "VIPR"

// Byte 4 of the Viper GC Header (combine them with |)
#define FLAG_DISABLE_CHIP     0x01
#define FLAG_EXTENDED_MODE    0x04
#define FLAG_COMMAND_MODE     0x08
#define FLAG_GC_FLASH_ACCESS  0x80

// Byte 5 of the Viper GC Header (default lid sensor status)
#define FLAG_LID_OPEN         0x00
#define FLAG_LID_CLOSED       0x01
#define FLAG_LID_PASSTHRU     0x02

#define ADDR_IPL              0x81300000
#define ADDR_ENCRYPTED_IPL    0x81500000
#define ADDR_VIPER_256KB_TEMP_BUFFER 0x81710000
#define ADDR_VIPER_FLASH      0x81760000

// Initialize ViperGC, and read Original BIOS (decrypted) to ADDR_IPL in memory.
// You have to call it when (and only if) FLAG_EXENTED_MODE is set.
void ViperInit();

// Force lid sensor status (use FLAG_LID_*)
// Call it only if FLAG_EXTENDED_MODE and FLAG_COMMAND_MODE are set.
void ViperWriteToLid(unsigned char c);

// Read Viper GC Programmer switch 2 and lid sensor status.
// Call it only if FLAG_EXTENDED_MODE and FLAG_COMMAND_MODE are set.
// Returns switch 2 in bit 0 and Lid sensor status in bit 1.
unsigned char ViperReadSwitchAndLid();

// Debug write to PC (for debugging purposes). 
// Call it only if FLAG_EXTENDED_MODE and FLAG_COMMAND_MODE are set.
void ViperWriteToPC(unsigned char c);

// Debug read from PC (for debugging purposes).
// Call it only if FLAG_EXTENDED_MODE and FLAG_COMMAND_MODE are set.
unsigned char ViperReadFromPC();

// Exit command mode. You have to call it before running any code accessing
// the IPL, RTC, Memory card slot 1, Broadband adapter or modem (such as the
// original IPL) if FLAG_EXENTED_MODE and FLAG_COMMAND_MODE are set.
void ViperExitCommandMode();

// Sample Viper GC Flash access, read viper.c for more information.
// Call it only if FLAG_EXTENDED_MODE and FLAG_COMMAND_MODE and 
// FLAG_GC_FLASH_ACCESS are set.
unsigned char ViperGetFlashManufacturerID();

#endif
